using System;
using System.Runtime.InteropServices;
using System.Text;

namespace Sony
{
	namespace NP
	{
		public class System
		{
			
			[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 0)]
			public struct Bandwidth
			{
				public float uploadBPS;
				public float downloadBPS;
			};


			public enum EnumConnectionStatus
			{
				NET_CTL_STATE_DISCONNECTED = 0,
				NET_CTL_STATE_CONNECTING = 1,
				NET_CTL_STATE_IPOBTAINING = 2,
				NET_CTL_STATE_IPOBTAINED = 3,
			}

			public enum EnumNatStunStatus
			{
				NET_CTL_NATINFO_STUN_UNCHECKED = 0,
				NET_CTL_NATINFO_STUN_FAILED = 1,
				NET_CTL_NATINFO_STUN_OK = 2,
			}
			
			public enum EnumNatType
			{
				NET_CTL_NATINFO_NAT_TYPE_1 = 1,
				NET_CTL_NATINFO_NAT_TYPE_2 = 2,
				NET_CTL_NATINFO_NAT_TYPE_3 = 3,
			}

			[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 0)]
			public struct NetInfoBasic
			{
				public EnumConnectionStatus connectionStatus;
				IntPtr _ipAddress;
				public EnumNatType natType;
				public EnumNatStunStatus natStunStatus;
				public int natMappedAddr;
				public string ipAddress { get { return Marshal.PtrToStringAnsi(_ipAddress); } }
			};

			[DllImport("UnityNpToolkit")]
			private static extern bool PrxNetInfoIsBusy();

			[DllImport("UnityNpToolkit")]
			private static extern bool PrxNetInfoGetLastError(out ResultCode result);

            [DllImport("UnityNpToolkit")]
            private static extern bool PrxNetCtlGetLastConnectionError(out ResultCode result);

			public static bool GetLastError(out ResultCode result)
			{
				PrxNetInfoGetLastError(out result);
				return result.lastError == ErrorCode.NP_OK;
			}

			[DllImport("UnityNpToolkit")]
			private static extern ErrorCode PrxNetInfoRequestBandwidth();
			[DllImport("UnityNpToolkit")]
			private static extern ErrorCode PrxNetInfoGetBandwidth(out Bandwidth bandwidth);

			[DllImport("UnityNpToolkit")]
			private static extern ErrorCode PrxNetInfoRequestInfo();
			[DllImport("UnityNpToolkit")]
			private static extern ErrorCode PrxNetInfoGetInfo(out NetInfoBasic info);

			public enum NetDeviceType
			{
				Wireless,
				Wired,
				Phone,
			};

			[DllImport("UnityNpToolkit")]
			private static extern NetDeviceType PrxNetInfoGetDeviceType();

			public static NetDeviceType GetNetworkDeviceType()
			{
				return PrxNetInfoGetDeviceType();
			}

			[DllImport("UnityNpToolkit")]
			private static extern long PrxGetNetworkTime();

			public static event NP.Messages.EventHandler OnSysEvent;
			public static event NP.Messages.EventHandler OnSysResume;
			public static event NP.Messages.EventHandler OnSysNpMessageArrived;
			public static event NP.Messages.EventHandler OnSysStorePurchase;
			public static event NP.Messages.EventHandler OnSysStoreRedemption;
			public static event NP.Messages.EventHandler OnConnectionUp;
			public static event NP.Messages.EventHandler OnConnectionDown;
			public static event NP.Messages.EventHandler OnGotBandwidth;
			public static event NP.Messages.EventHandler OnGotNetInfo;
			public static event NP.Messages.EventHandler OnNetInfoError;

			public static bool connectionUp = true;

			public static bool IsConnected
			{
				get { return connectionUp; }
			}

			public static bool RequestBandwidthInfoIsBusy()
			{
				return PrxNetInfoIsBusy();
			}
			
			public static ErrorCode RequestBandwidthInfo()
			{
				return PrxNetInfoRequestBandwidth();
			}

			public static Bandwidth GetBandwidthInfo()
			{
				Bandwidth bandwidth = new Bandwidth();
				PrxNetInfoGetBandwidth(out bandwidth);
				return bandwidth;
			}

			public static ErrorCode RequestNetInfo()
			{
				return PrxNetInfoRequestInfo();
			}
			
			public static NetInfoBasic GetNetInfo()
			{
				NetInfoBasic info = new NetInfoBasic();
				PrxNetInfoGetInfo(out info);
				return info;
			}

			public static long GetNetworkTime()
			{
				return PrxGetNetworkTime();
			}

            public static bool GetLastConnectionError(out ResultCode result)
            {
                PrxNetCtlGetLastConnectionError(out result);
                return result.lastError == ErrorCode.NP_OK;
            }

			public static bool ProcessMessage(NP.Messages.PluginMessage msg)
			{
				switch (msg.type)
				{
					case NP.Messages.MessageType.kNPToolKit_ConnectionUp:
						connectionUp = true;
						if (OnConnectionUp != null) OnConnectionUp(msg);
						return true;

					case NP.Messages.MessageType.kNPToolKit_ConnectionDown:
						connectionUp = false;
						if (OnConnectionDown != null) OnConnectionDown(msg);
						return true;

					case NP.Messages.MessageType.kNPToolKit_SysEvent:
						if (OnSysEvent != null) OnSysEvent(msg);
						break;

					case NP.Messages.MessageType.kNPToolKit_SysResume:
						if (OnSysResume != null) OnSysResume(msg);
						break;

					case NP.Messages.MessageType.kNPToolKit_SysNpMessageArrived:
						if (OnSysNpMessageArrived != null) OnSysNpMessageArrived(msg);
						break;
						
					case NP.Messages.MessageType.kNPToolKit_SysStoreRedemption:
						if (OnSysStoreRedemption != null) OnSysStoreRedemption(msg);
						break;
						
					case NP.Messages.MessageType.kNPToolKit_SysStorePurchase:
						if (OnSysStorePurchase != null) OnSysStorePurchase(msg);
						break;

					case NP.Messages.MessageType.kNPToolKit_NetInfoGotBandwidth:
						if (OnGotBandwidth != null) OnGotBandwidth(msg);
						break;

					case NP.Messages.MessageType.kNPToolKit_NetInfoGotBasic:
						if (OnGotNetInfo != null) OnGotNetInfo(msg);
						break;

					case NP.Messages.MessageType.kNPToolKit_NetInfoError:
						if (OnNetInfoError != null) OnNetInfoError(msg);
						break;
				}

				return false;
			}
		}
	} // NP
} // Sony
